/* Check program */

#include <stdio.h>
#include <stdlib.h>
#include "Packet.h"
#include "ErrCode.h"
#include "ErrMsg.h"

#define FNAME	"2check_A"
#define N_TM	20
#define REPEAT	1

#define BUF_SIZE	16000

int MyProc(int nArg);


//=======================================
int main(int argc, char *argv[])
{
	int nErr;
	int nArg = N_TM;

	//-----<argument>-----
	if ( argc==2 )	nArg = atoi(argv[1]);
	
	//-----<operation>-----
	nErr = MyProc(nArg);
	
	//-----<operation result>-----
	puts(FNAME);
	printf( pszErrString[nErr] );
	

//------Clear fifo
	while ( ::get_rxcnt() )
	{
		if ( ::clr_fifo() ) break;
		printf("\n...clearing fifo...\n");
	}


	return nErr;
}

//=======================================
int MyProc(int nArg)
{
	int nErr=0;

	CPacket pkt_AScan(BUF_SIZE);
	
//==================<Command Frame Set>========================
	//-----A-scan check----
//puts("A-scan Frames set!");
	unsigned char A;
	unsigned char wcnt=0;

for ( wcnt=0; wcnt<REPEAT; wcnt++ )
{
	for ( A=0; A<16; A++ )
	{
		if
		(
			pkt_AScan.AddFrame(nArg,A,0,0)	||	//Set A=0..15
			pkt_AScan.AddFrame(nArg,0,1,0)		//dataway read
		)
		return 2;
	}
}

//puts("Cycle Go!");
	unsigned long er;
	if ( er=pkt_AScan.Go(0) )
	{
		printf("er=%d\n",er);
		return 3;
	}
//==================<Comparison!>========================
unsigned long i;
unsigned long code, data;
unsigned long ErrAmount=0;
char szMsg[0xFF];
struct DATAWAYSTAT dataway;
//-------
puts("A scan compare...");
	unsigned char sentA;
	
	i=0;
	while ( pkt_AScan.ReadFrame(i,&code, &data)==0 )
	{
		memset( szMsg, 0x00, sizeof(szMsg) );
		sprintf( szMsg, "%d\tCHECK :\t0x%08x\t0x%08x\n", i, code, data);

		sentA = (code & 0x0000FF00)>>8;
		i++;
		pkt_AScan.ReadFrame(i,&code, &data);

		sprintf(szMsg+strlen(szMsg), "%d\tREAD :\t0x%08x\t0x%08x\n", i, code, data);

		DecTM(&dataway, data);
		i++;
		
		if ( sentA != dataway.A )
		{
			create_logfile(FNAME, szMsg);
			ErrAmount++;
		}
	}
//-------


	if ( ErrAmount )	return 4;
	
	return nErr;
}

